#!python3

from os import scandir
from os.path import join as join_path, splitext
from shutil import copytree

path = 'tagged'
dest = 'contains_music'
desired_file_extensions = ('.mp3', '.ogg', '.flac', 'm4a', 'aac', 'wma')
hidden_file_prefixes = ('.', '_')

other_file_types = set()

# recursive function that either returns true, copies a folder or returns null
def keep_folder(path):
	entries = scandir(path)
	keep = False
	for entry in entries:
		if entry.is_dir():
			# recurse into this folder
			next_path = join_path(path, entry.name)
			if (keep_folder(next_path)):
				print("Will keep folder: %s" % next_path)
				copytree(next_path, join_path(dest, next_path))

		elif entry.is_file():
			if keep_file(entry):
				# if one file is found that I want to keep, the whole folder will be copied
				keep = True
				# parsing the other files or folders in this folder will not be necessary
				break
			else:
				# add this file to the list of file types that were selected for copying
				other_file_types.add(splitext(entry.name)[1])

	return keep

# returns true if the file ends with one of the desired file extensions
def keep_file(entry):
	return not entry.name.startswith(hidden_file_prefixes) \
		and entry.name.lower().endswith(desired_file_extensions)


if __name__ == '__main__':
	# recursively walk through the folder structure
	keep_folder(path)

	print('---\nFile types that were not picked for copying:\n', other_file_types)