﻿var assert = require('assert');

var SolverModule = require('../lib/solver.js'),
    Algo = SolverModule.Solver;
var debug = false;

describe('Initialization tests', function () {
    it('No rain means result equals initial landscape', function () {
        var landscape = [2, 4, 1, 17];
        var solver = new Algo(0, landscape);
        solver.calculate();
        
        assert.strictEqual(solver.result.length, 4);
        assert.deepEqual(solver.result, landscape);
    });
});


describe('One hour rain sessions:', function () {
    var simpleTests = [
        { hours: 1, landscape: [1, 5], result: [3, 5] },
        { hours: 1, landscape: [1, 5, 3], result: [2.5, 5, 4.5] },
        { hours: 1, landscape: [4, 2], result: [4, 4] },
        { hours: 1, landscape: [1, 5, 5, 4], result: [4, 5, 5, 5] },
        { hours: 1, landscape: [1, 5, 5, 1], result: [3, 5, 5, 3] },
        { hours: 1, landscape: [1, 6, 6, 4, 6], result: [4, 6, 6, 6, 6] },
        { hours: 1, landscape: [1, 5, 5, 4, 5], result: [5, 5, 5, 5, 5] },
        { hours: 1, landscape: [1, 5, 5, 4, 5, 6], result: [26/5, 26/5, 26/5, 26/5, 26/5, 6] },
        { hours: 1, landscape: [1, 3, 4], result: [3.5, 3.5, 4] }, 
        { hours: 1, landscape: [1, 3, 4, 4], result: [4, 4, 4, 4] }, 
        { hours: 1, landscape: [1, 5, 4], result: [3, 5, 5] },
        { hours: 1, landscape: [4, 5, 5, 1], result: [5, 5, 5, 4] },
        { hours: 1, landscape: [1, 3, 1], result: [2.5, 3, 2.5] },
        { hours: 1, landscape: [1, 2, 1], result: [7/3, 7/3, 7/3] },
    ];
    //simpleTests = simpleTests.slice(0, 8);
    
    simpleTests.forEach(function (testSet) {
        var solver = new Algo(testSet.hours, testSet.landscape);
        var expected = testSet.result;
        
        it(solver.toString() + ' expect as result: [' + expected.join(', ') + ']', function () {
            solver.calculate();
            
            if (debug) {
                console.log('--------------');
                console.log(solver.result);
            }
            
            assert.deepEqual(solver.result, expected);
        });
    });
});

/**/
describe('Two hour rain sessions:', function () {
    var simpleTests = [
        { hours: 2, landscape: [1, 5], result: [5, 5] },
        { hours: 2, landscape: [1, 5, 4], result: [16/3, 16/3, 16/3] },
        { hours: 2, landscape: [1, 5, 5, 4], result: [5.75, 5.75, 5.75, 5.75] },
        { hours: 2, landscape: [1, 5, 6, 4], result: [6, 6, 6, 6] },
        { hours: 2, landscape: [4, 6, 5, 1], result: [6, 6, 6, 6] },
        { hours: 2, landscape: [1, 5, 7, 4], result: [5.5, 5.5, 7, 7] },
        { hours: 2, landscape: [4, 2], result: [5, 5] },
        { hours: 2, landscape: [6, 2], result: [6, 6] },
        { hours: 2, landscape: [1, 5, 5, 1], result: [5, 5, 5, 5] },
        { hours: 2, landscape: [1, 6, 5, 1], result: [4, 6, 5.5, 5.5] },
        { hours: 2, landscape: [1, 3, 4], result: [4+2/3, 4+2/3, 4+2/3] },
        { hours: 2, landscape: [1, 3, 5, 7, 11], result: [6+1/3, 6+1/3, 6+1/3, 7, 11] },
    ];
    //simpleTests = simpleTests.slice(0, 8);
    
    simpleTests.forEach(function (testSet) {
        var solver = new Algo(testSet.hours, testSet.landscape);
        var expected = testSet.result;
        
        it(solver.toString() + ' expect as result: [' + expected.join(', ') + ']', function () {
            solver.calculate();
            assert.deepEqual(solver.result, expected);
        });
    });    
});


describe('Random rain amounts', function () {
    var testData = [
        { hours: 5, landscape: [5, 5], result: [10, 10] },
        { hours: 100, landscape: [701, 384], result: [701, 584] },
        { hours: 100000, landscape: [300, 300, 250000], result: [150300, 150300, 250000 ] },
    ];
    //testData = testData.slice(0,2);

    testData.forEach(function (testSet) {
        var solver = new Algo(testSet.hours, testSet.landscape);
        var expected = testSet.result;
        
        it(solver.toString() + ' expect as result: [' + expected.join(', ') + ']', function () {
            solver.calculate();
            assert.deepEqual(solver.result, expected);
        });
    });
});

describe('Completely overflown landscapes', function () {
    var testData = [
        { hours: 2, landscape: [1, 5], result: 5 },
        { hours: 3, landscape: [4, 2], result: 6 },
        { hours: 5, landscape: [1, 5, 5, 1], result: 8 },
        { hours: 2, landscape: [1, 3, 4], result: 4+2/3 },
    ]
    
    testData.forEach(function (data) {
        var solver = new Algo(data.hours, data.landscape);

        it(solver.toString() + ', expect a height of ' + data.result, function () {
            var expected = data.landscape.map(function () { return data.result; });

            solver.calculate();

            assert.deepEqual(solver.result, expected);
        });
    });
});
