﻿"use strict"

var assert = require('assert');

var SolverModule = require('./lib/solver.js'),
    Algo = SolverModule.Solver;

var simpleTests = [
    { hours: 2, landscape: [1, 5, 6, 4], result: [6, 6, 6, 6] },
    { hours: 1, landscape: [1, 5], result: [3, 5] },
    { hours: 1, landscape: [1, 5, 3], result: [2.5, 5, 4.5] },
    { hours: 1, landscape: [4, 2], result: [4, 4] },
    { hours: 1, landscape: [1, 5, 5, 4], result: [4, 5, 5, 5] },
    { hours: 1, landscape: [1, 5, 5, 1], result: [3, 5, 5, 3] },
    { hours: 1, landscape: [1, 6, 6, 4, 6], result: [4, 6, 6, 6, 6] },
    { hours: 1, landscape: [1, 5, 5, 4, 5], result: [5, 5, 5, 5, 5] },
    { hours: 1, landscape: [1, 5, 5, 4, 5, 6], result: [26 / 5, 26 / 5, 26 / 5, 26 / 5, 26 / 5, 6] },
    { hours: 1, landscape: [1, 3, 4], result: [3.5, 3.5, 4] }, 
    { hours: 1, landscape: [1, 3, 4, 4], result: [4, 4, 4, 4] }, 
    { hours: 1, landscape: [1, 5, 4], result: [3, 5, 5] },
    { hours: 1, landscape: [4, 5, 5, 1], result: [5, 5, 5, 4] },
    { hours: 1, landscape: [1, 3, 1], result: [2.5, 3, 2.5] },
    { hours: 1, landscape: [1, 2, 1], result: [7 / 3, 7 / 3, 7 / 3] },
];
var number = 0;
simpleTests = simpleTests.slice(number, number+1);


simpleTests.forEach(function (testSet) {
    
    var solver = new Algo(testSet.hours, testSet.landscape);
    var expected = testSet.result;
    
    console.log(solver.toString() + ' expect as result: [' + expected.join(', ') + ']');
    
    solver.calculate();
    
    console.log(solver.toString(true));
    assert.deepEqual(solver.result, expected, 'The solution should match the expected result');
});
