﻿/**
 * useful things for debugging
 */

"use strict"

function printRegionsGroupedByHeight(groupedByHeight, index) {
    var str = '<empty>';
    
    if (isNaN(parseInt(index))) {
        var keys = Object.keys(groupedByHeight);
        str = '{\n' + keys.map(singleGroupToString).join(',\n') + '\n}';
    } else {
        str = singleGroupToString(index);
    }
    
    console.log('Regions grouped by height: ' + str);
    
    function singleGroupToString(index) {
        let output = ' ' + index + ': [';
        if (!Array.isArray(groupedByHeight[index])) { return output + '0]'; }
        
        output += '\n' + groupedByHeight[index].map(function (region) {
            return '  ' + region.toString();
        }).join(',\n');
        return output += '\n ]';
    }
}


module.exports = {
    regionsGroupedByHeight: printRegionsGroupedByHeight
}