﻿# Water

## Description of the problem
Rain is pouring for a defined duration on a landscape that consists of multiple columns, each with its own height.

### Rules

1. There is an invisible border to the left and to the right of the provided landscape with a height of infinity.
2. Each hour of rain pours one unit of rain into each column.
3. The rain flows from a higher to a lower column. If the column to the left and to the right are both lower, then the rain distributes evenly between those two.

## Reasoning for the solution  
### 1. Bottom up  
At first glance it might seem logical to start pouring the rain from above one hour at a time and distribute it like that.  
But if the landscape is slowly filled from the bottom up, many many edge cases will never occur and the problem will be a lot easier to implement.

### 2. Create regions
Instead of working with each column, I chose to group columns of the same height together into a region.  
This will reduce the number of elements that need checking and allows me to easily calculate the water capacity of a region and also if the water should flow somewhere from this element.

### 3. Gather the rain in the trenches/ local minima
If the landscape will get bigger, it will be very inefficient to pour the water into each column.  
Instead it would be easier to find all local minima in the landscape and divide the rain among those minima in the beginning.  
This of course costs some time in the beginning of the calculation, especially if the worst case should occur: A zigzag landscape.

### 4. Shortcut if a landscape overflows
I can skip a lot of calculation if I add a case that checks in the beginning if more water will be poured into the landscape than it can take.


## Code
The code for solving this problem is split into two files: _region.js_ and _solver.js_.  

- _region.js_ contains the prototype for each Region instance with the necessary functions to  pour rain into itself or another region and merge it with neighbors to create a bigger region. Also it contains the specific border, a region with a height of POSITIVE_INFINITY.  
- _solver.js_ contains the code to create the double-linked list of regions from the entered landscape array, and to pour all the rain into the landscape.  

To solve an example landscape the file _sample.js_ can be executed, e.g. from the console 
```
npm install
npm start
```

## Tests
To run the tests of the solution, execute: 
```
npm install
npm test
```
